<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';
require_once '../../helpers/tanggal.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Ambil kas masuk (kasir, simpanan)
$kas_masuk = $db->query("
    SELECT tanggal, total AS jumlah, 'Kasir' AS sumber 
    FROM kasir_transaksi
    UNION ALL
    SELECT tanggal, jumlah, 'Simpanan' 
    FROM simpanan_transaksi
    ORDER BY tanggal DESC
");

// Ambil kas keluar (pinjaman cair)
$kas_keluar = $db->query("
    SELECT tanggal, jumlah, 'Pinjaman' AS keterangan
    FROM pinjaman
    ORDER BY tanggal DESC
");
?>

<h2>Kas Koperasi</h2>

<h3>Kas Masuk</h3>
<table class="table">
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Sumber</th>
            <th>Jumlah</th>
        </tr>
    </thead>
    <tbody>
        <?php while($m = $kas_masuk->fetch_assoc()): ?>
        <tr>
            <td><?= tanggal($m['tanggal']); ?></td>
            <td><?= $m['sumber']; ?></td>
            <td><?= format_uang($m['jumlah']); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<hr>

<h3>Kas Keluar</h3>
<table class="table">
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Keterangan</th>
            <th>Jumlah</th>
        </tr>
    </thead>
    <tbody>
        <?php while($k = $kas_keluar->fetch_assoc()): ?>
        <tr>
            <td><?= tanggal($k['tanggal']); ?></td>
            <td><?= $k['keterangan']; ?></td>
            <td><?= format_uang($k['jumlah']); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
